/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs;

import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Input;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class Output
extends Input {
    private static final String NBT_COMPLETED_SETS = "CompletedSets";
    private long completedSets;

    public Output(@Nonnull ItemStack itemStack, int quantityPerCraft) {
        super((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{itemStack}), 0L);
        this.quantityPerCraft = quantityPerCraft;
    }

    public Output(@Nonnull FluidStack fluidStack, int quantityPerCraft) {
        super(fluidStack, 0L);
        this.quantityPerCraft = quantityPerCraft;
    }

    public Output(@Nonnull NBTTagCompound compound) throws CraftingTaskReadException {
        super(compound);
        this.completedSets = compound.func_74763_f(NBT_COMPLETED_SETS);
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNbt(@Nonnull NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74772_a(NBT_COMPLETED_SETS, this.completedSets);
        return compound;
    }

    public void setCompletedSets(long completedSets) {
        this.completedSets = completedSets;
    }

    public long getCompletedSets() {
        return this.completedSets;
    }

    public long getMissingSets() {
        return (long)Math.ceil((double)this.amountNeeded / (double)this.quantityPerCraft) - this.getCompletedSets();
    }
}

